---------- Sous-requtes where ----------------------
use AdventureWorksDW2019

-- Exemples simples pouvant tre remplacs par des jointures

-- A.1 Quels sont les produits diffrents qui ont dj t command ?
-- table FactInternetSales
-- 158 produits command
select ProductKey, EnglishProductName
from Dimproduct
where ProductKey in 
					( select distinct ProductKey
					from FactInternetSales)

-- A.2 Quels sont les produits diffrents qui n'ont pas dj t command ?
-- Rsultat : 448 
set statistics time on
dbcc freeproccache

-- excution 1390 en moyenne UC et TE
select ProductKey, EnglishProductName
from Dimproduct
where ProductKey not in 
					( select distinct ProductKey
					from FactInternetSales)

-- excution join : 15 UC et 44 TE
select distinct p.ProductKey, EnglishProductName
from Dimproduct p left join FactInternetSales s ON p.ProductKey =s.ProductKey
where s.ProductKey IS NULL

-- B.1 Quelles sont les promotions (nom franais) avec des ventes ? 
-- Tables FactInternetSales et Dimpromotion
-- 4 rsultats dont 1 nomme 'aucune remise'
select FrenchPromotionName
from DimPromotion
where promotionkey in (select distinct promotionkey
					   from FactInternetSales)

-- B.2 Quelles sont les noms des promotions (en franais) pour lesquelles, il n'y a jamais eu de ventes ?
-- 12 remises
select FrenchPromotionName
from DimPromotion
where promotionkey not in (select distinct promotionkey
					   from FactInternetSales)

-- Exemples ne pouvant pas tre remplacs par des jointures !

-- C.1 Je souhaite rcuprer les promotions (frenchPromotionName) ralises par le revendeur 'Modular Cycle Systems' mais pas par le revendeur 'Advanced Bike Components'
-- Tables DimReseller, FactResellerSales, DimPromotion
-- Rsultat : 1 promotion : Dstockage Vlo de route 650

-- requte principale : Modular Cycle Systems
select distinct p.PromotionKey, p.FrenchPromotionName
from DimReseller r  join FactResellerSales rs on r.ResellerKey=rs.ResellerKey
					join DimPromotion p on p.promotionkey= rs.promotionkey
where resellerName = 'Modular Cycle Systems'
 and p.PromotionKey not in (
				-- requte secondaire : Advanced Bike Components
				select distinct p.PromotionKey
				from DimReseller r join FactResellerSales rs on r.ResellerKey=rs.ResellerKey
								   join DimPromotion p on p.promotionkey= rs.promotionkey
				where resellerName = 'Advanced Bike Components'
						)

-- C.2 Je souhaite rcuprer les produits (pr.englishproductname) vendus par le revendeur 'Modular Cycle Systems' mais pas le revendeur 'Advanced Bike Components'
-- Rsultat : 16 produits vendus que par Modular

-- requte principale : Modular Cycle Systems = 73
select distinct pr.productkey, pr.englishproductname
from DimReseller r  join FactResellerSales rs on r.ResellerKey=rs.ResellerKey
					join Dimproduct pr on pr.productkey=rs.ProductKey
where resellerName = 'Modular Cycle Systems'
 and pr.productkey not in (
				-- requte secondaire : Advanced Bike Components = 133
				select distinct pr.productkey
				from DimReseller r join FactResellerSales rs on r.ResellerKey=rs.ResellerKey
								   join Dimproduct pr on pr.productkey=rs.ProductKey
				where resellerName = 'Advanced Bike Components'
						)

-------------------------------------------------

-- D.1
-- Table Factresellersales : 
-- Afficher la somme des quantit vendues en 2012 que si plus que la somme des quantits en 2011
-- Rsultat : 1 (81328)
select sum(OrderQuantity) as 'total quantit vendue'
From FactResellerSales s
where year(s.orderdate) = 2012
having sum(OrderQuantity) > (
		select sum(OrderQuantity) as 'total quantit vendue'
		From FactResellerSales ss
		where year(ss.orderdate) = 2011)

-- D.2 Corrlation Suite D.1
-- Afficher les revendeurs avec plus de quantits vendues en 2012 qu'en 2011
-- Rsultat : 132
select sum(OrderQuantity) as 'total quantit vendue', r.ResellerKey, ResellerName
From FactResellerSales s join DimReseller r on r.ResellerKey=s.ResellerKey
where year(s.orderdate) = 2012
group by r.ResellerKey, ResellerName
having sum(OrderQuantity)  > 
		( select sum(OrderQuantity) as 'total quantit vendue'
		  From FactResellerSales ss join DimReseller rr on rr.ResellerKey=ss.ResellerKey
		  where year(ss.orderdate) = 2011
		  and r.ResellerKey=rr.ResellerKey
		  group by rr.ResellerKey, ResellerName
		)

-- D.3 Corrlation Suite D.2
-- je veux afficher en plus le nombre de ventes 
-- et regrouper le tout en plus par pays (+revendeur dj prsent)
-- rsultat : 132 lignes
select EnglishCountryRegionName, r.ResellerKey, ResellerName,
		sum(OrderQuantity) as 'somme quantits',
		count(distinct SalesOrderNumber) as 'nombre de ventes'
From FactResellerSales f Join DimReseller r on f.ResellerKey=r.ResellerKey
						 Join DimGeography g on g.GeographyKey=r.GeographyKey
where year(orderdate)= 2012
Group by EnglishCountryRegionName, r.ResellerKey, ResellerName
having sum(OrderQuantity) >
			-- copier/coller puis changer le nom des tables dans sous requte + ANNEE 2012
			-- rajouter where entre le pays et le revendeur
		(select sum(OrderQuantity) as 'somme quantits'
		From FactResellerSales ff Join DimReseller rr on ff.ResellerKey=rr.ResellerKey
						 Join DimGeography gg on gg.GeographyKey=rr.GeographyKey
		where year(orderdate)= 2011
			and rr.ResellerKey=r.ResellerKey
			and gg.EnglishCountryRegionName=g.EnglishCountryRegionName
		Group by EnglishCountryRegionName, rr.ResellerKey, ResellerName
		)
order by resellerkey asc

-- D.4 Corrlation Suite D.3
-- quand le nombre de vente en 2013 (par pays et revendeur) est infrieur  celle de 2012
-- Rsultat : 6 lignes
select EnglishCountryRegionName, r.ResellerKey, ResellerName,
		sum(OrderQuantity) as 'somme quantits',
		count(distinct SalesOrderNumber) as 'nombre de ventes'
From FactResellerSales f Join DimReseller r on f.ResellerKey=r.ResellerKey
						 Join DimGeography g on g.GeographyKey=r.GeographyKey
where year(orderdate)= 2013
Group by EnglishCountryRegionName, r.ResellerKey, ResellerName
having sum(OrderQuantity) >
		(select sum(OrderQuantity) as 'somme quantits'
		 From FactResellerSales ff Join DimReseller rr on ff.ResellerKey=rr.ResellerKey
						 Join DimGeography gg on gg.GeographyKey=rr.GeographyKey
		where year(orderdate)= 2012 
			and rr.ResellerKey=r.ResellerKey
			and gg.EnglishCountryRegionName=g.EnglishCountryRegionName
		Group by EnglishCountryRegionName, rr.ResellerKey, ResellerName
		)

AND count(distinct SalesOrderNumber) <
			-- mme requte que premire sous-requte mais avec nombre de ventes dans le select
		(select count(distinct SalesOrderNumber) as 'nombre de ventes'
		 From FactResellerSales ff Join DimReseller rr on ff.ResellerKey=rr.ResellerKey
						 Join DimGeography gg on gg.GeographyKey=rr.GeographyKey
		where year(orderdate)= 2012 
			and rr.ResellerKey=r.ResellerKey
			and gg.EnglishCountryRegionName=g.EnglishCountryRegionName
		Group by EnglishCountryRegionName, rr.ResellerKey, ResellerName
		)

---------- Sous-requtes FROM ----------------------

-- E.1 Quelle est en moyenne, le nombre de clients par promotion ?
-- en excluant la promotionkey 1 (correspondant  no discount)
-- Table FactInternetSales
-- Rsultat : 674
select avg([nombre de clients]) as Moyenne
from    (
-- Requte principale : La moyenne (calcul final)
		-- Requte secondaire : Compter le nombre de couleurs par produits (1er calcul  faire)
		select count(distinct customerkey) as 'nombre de clients', promotionkey
		From FactInternetSales
		where promotionkey <> 1
		group by promotionkey
		) as nb_col

-- E.2 Quelle est la diffrence entre la moyenne de clients par promotion en 2013 et en 2012 ?
-- Rsultat : 11 502
select avg([nombre de clients 2013]) - avg([nombre de clients 2012]) as Diff
from    (
-- Requte principale : La moyenne (calcul final)
		-- Requte secondaire a : Compter le nombre de clients par promotion en 2013
		select count(customerkey) as 'nombre de clients 2013', promotionkey
		From FactInternetSales
		where year(orderdate) = 2013
		group by promotionkey
		) as nb_col2013 ,
		(
		-- Requte secondaire b : Compter le nombre de clients par promotion en 2012
		select count(customerkey) as 'nombre de clients 2012', promotionkey
		From FactInternetSales
		where year(orderdate) = 2012
		group by promotionkey
		) as nb_col2012

-- E.3.a DIffrence performance sur cas de comparaison de listing entre WHERE ET FROM
-- Version where environ 1500 ms 
-- les noms revendeurs qui ont fait des ventes en 2012 et en 2013
set statistics time on
dbcc freeproccache

select distinct r.ResellerKey, ResellerName
From dimreseller as r JOIN FactResellerSales as s on r.ResellerKey=s.ResellerKey
where year(orderdate) = 2012
 AND r.ResellerKey IN 
		(select distinct ResellerKey
		From FactResellerSales
		where year(orderdate) = 2013)

-- E.3.b mme chose mais avec un FROM - 33 ms
select distinct REV12.Resellername, rev12.ResellerKey
From 
		(select distinct r.ResellerKey, ResellerName -- rajout du resellername pour pouvoir l'afficher dans requte principale
		From FactResellerSales join DimReseller r on FactResellerSales.ResellerKey = r.ResellerKey
		where year(orderdate) = 2012) as REV12 JOIN

		(select distinct ResellerKey
		From FactResellerSales
		where year(orderdate) = 2013) as REV13

	ON rev12.ResellerKey = rev13.ResellerKey

-- OU jointure dans le from principal pour avoir accs au nom du revendeur
select distinct ResellerName,r.ResellerKey
from 
		(select distinct ResellerKey from FactResellerSales 
		where year(OrderDate)= 2012) REV12
join	(select distinct ResellerKey from FactResellerSales 
		where year(OrderDate)= 2013) REV13
        on REV12.ResellerKey=REV13.ResellerKey
join DimReseller r on r.ResellerKey=REV13.ResellerKey

---------- Sous-requtes select ----------------------

-- F.1 Afficher le prix moyen (lisprice) par couleur et le prix moyen global (toutes couleurs confondues)
-- Seulement pour les couleurs qui ont une moyenne suprieure  la moyenne globale
-- Table DImproduct (quand listprice est renseign)
-- Rsultat : 5 couleurs

select color, avg(listprice) as 'moy par couleur',
(select avg(listprice) From DimProduct) Moy_listprice
from DimProduct
where listprice is not null 
group by color
Having avg(Listprice) > (select avg(listprice)
					From DimProduct)

-- G.1 Je souhaite afficher le nom (lastname), le taux de base du salaire (baserate) et le dpartement des employs
-- Ainsi que la moyenne du taux de base de tous les employs
-- Rsultat : 296
SELECT lastname, baserate, departmentname
, (SELECT AVG(baserate) FROM DimEmployee) as moyenne_tauxbase
 FROM DimEmployee e

-- G.2 Suite du G.1, pour chaque ligne de rsultat (chaque employ), 
-- je souhaite galement afficher le taux de base de son dpartement
-- Si dupont est du dpartement des ventes alors sur sa ligne doit s'afficher dans ma nouvelle colonne : la moyenne du dpartement des ventes
SELECT lastname, baserate, departmentname,
	(SELECT AVG(baserate) FROM DimEmployee) as moyenne_tauxbase,
	(SELECT AVG(baserate) FROM DimEmployee
    WHERE DepartmentName = e.departmentname) as moy_tauxbase_dep
 FROM DimEmployee e

-- G.3 Afficher les rsultats quand le taux de base de l'employ
-- est infrieure  la moyenne des taux de base de son dpartement
SELECT lastname, baserate, departmentname,
	--(SELECT AVG(baserate) FROM DimEmployee) as moyenne_tauxbase,
	(SELECT AVG(baserate) FROM DimEmployee
    WHERE DepartmentName = e.departmentname) as moy_tauxbase_dep
 FROM DimEmployee e
 where baserate < (SELECT AVG(baserate) FROM DimEmployee
					WHERE DepartmentName = e.departmentname)